package band.effective.office.backend.feature.authorization.dto

import jakarta.validation.constraints.NotBlank

/**
 * DTO for login request.
 */
data class LoginRequest(
    @field:NotBlank(message = "Username is required")
    val username: String,

    @field:NotBlank(message = "Password is required")
    val password: String
)

/**
 * DTO for Google authentication request.
 */
data class GoogleAuthRequest(
    @field:NotBlank(message = "ID token is required")
    val idToken: String
)

/**
 * DTO for refresh token request.
 */
data class RefreshTokenRequest(
    @field:NotBlank(message = "Refresh token is required")
    val refreshToken: String
)

/**
 * DTO for token response.
 */
data class TokenResponse(
    val accessToken: String,
    val refreshToken: String,
    val tokenType: String = "Bearer",
    val expiresIn: Long
)

/**
 * DTO for error response.
 */
data class ErrorResponse(
    val status: Int,
    val message: String,
    val timestamp: Long = System.currentTimeMillis()
)
