package band.effective.office.backend.feature.authorization.config

import band.effective.office.backend.feature.authorization.security.JwtAuthenticationFilter
import band.effective.office.backend.feature.authorization.service.AuthorizationService
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity
import org.springframework.security.config.http.SessionCreationPolicy
import org.springframework.security.web.SecurityFilterChain
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter

/**
 * Spring Security configuration.
 */
@Configuration
@EnableWebSecurity
class SecurityConfig(
    private val authorizationService: AuthorizationService
) {

    /**
     * Configures the security filter chain.
     */
    @Bean
    fun securityFilterChain(http: HttpSecurity): SecurityFilterChain {
        http
            .csrf { it.disable() }
            .cors { it.disable() }
            .sessionManagement { it.sessionCreationPolicy(SessionCreationPolicy.STATELESS) }
            .authorizeHttpRequests { authorize ->
                authorize
                    .requestMatchers("/auth/**").permitAll()
                    .requestMatchers("/swagger-ui.html/**", "/swagger-ui/**", "/api-docs/**", "/v3/api-docs/**").permitAll()
                    .requestMatchers("/actuator/**").permitAll()
                    .requestMatchers("/bookings/**").permitAll() // TODO for testing
                    .requestMatchers("/workspaces/**").permitAll() // TODO for testing
                    .anyRequest().authenticated()
            }
            .addFilterBefore(
                JwtAuthenticationFilter(authorizationService),
                UsernamePasswordAuthenticationFilter::class.java
            )

        return http.build()
    }

}
