package band.effective.office.tablet.core.ui.theme

import androidx.compose.ui.graphics.Color

/**
 * Dark theme colors
 */
internal val md_theme_dark_primary = Color(0xFFEE7234)
internal val md_theme_dark_onPrimary = Color(0xFFFAFAFA)
internal val md_theme_dark_secondary = Color(0xFFA262F7)
internal val md_theme_dark_background = Color(0xFF1E1C1A)
internal val md_theme_dark_surface = Color(0xFF252322)
internal val md_theme_dark_elevationBackground = Color(0xFF302D2C)
internal val md_theme_dark_mountainBackground = Color(0xFF3A3736)
internal val md_theme_dark_busyStatus = Color(0xFFF84C4C)
internal val md_theme_dark_freeStatus = Color(0xFF36C85F)
internal val md_theme_dark_onError = Color(0xFF95260E)
internal val md_theme_dark_onSuccess = Color(0xFF22B44B)
internal val md_theme_dark_secondaryButton = Color(0xFFFEFEFE)
internal val md_theme_dark_primaryTextAndIcon = Color(0xFFF9F9F9)
internal val md_theme_dark_secondaryTextAndIcon = Color(0xFF808080)
internal val md_theme_dark_tertiaryTextAndIcon = Color(0xFF6E6E6E)
internal val md_theme_dark_pressedPrimaryButton = Color(0xFFEC6521)
internal val md_theme_dark_disabledPrimaryButton = Color(0xFF483E38)

/**
 * Light theme colors
 */
internal val md_theme_light_primary = Color(0xFFE55A0F)
internal val md_theme_light_secondary = Color(0xFF6E00FE)
internal val md_theme_light_background = Color(0xFFFFFFFF)
internal val md_theme_light_surface = Color(0xFFFAFAFA)
internal val md_theme_light_elevationBackground = Color(0xFFF0F0F0)
internal val md_theme_light_mountainBackground = Color(0xFFF0F0F0)
internal val md_theme_light_busyStatus = Color(0xFFF84343)
internal val md_theme_light_freeStatus = Color(0xFF36C85F)
internal val md_theme_light_onError = Color(0xFFEB4C2A)
internal val md_theme_light_onSuccess = Color(0xFF22B44B)
internal val md_theme_light_secondaryButton = Color(0xFFE55A0F)
internal val md_theme_light_primaryTextAndIcon = Color(0xFF1F1814)
internal val md_theme_light_secondaryTextAndIcon = Color(0xFF747474)
internal val md_theme_light_tertiaryTextAndIcon = Color(0xFF979797)
internal val md_theme_light_pressedPrimaryButton = Color(0xFFED6F2F)
internal val md_theme_light_disabledPrimaryButton = Color(0xFFD2CAC6)

/**
 * Common UI element colors
 */
val textButton = Color(0xFFFFFFFF)
val roomInfoColor = Color(0xFFFAFAFA)
val alertColor = Color(0xFF95260E)
val disconnectColor = Color(0xFFD01E1E)
val undefineStateColor = Color(0xFF6E6E6E)
val subslotColor = Color(0xFFFAC6C6)
val deleteProgressColor = Color(0xFFEF7234)

/**
 * Scroll bar colors
 */
object ScrollBarColor {
    val background = Color(0xFF4D4D4D)
    val pistonColor = Color(0xFF808080)
}