module DropdownsHelper
  def dropdown_tag(toggle_text, options: {}, &block)
    content_tag :div, class: "dropdown" do
      data_attr = { toggle: "dropdown" }

      if options.has_key?(:data)
        data_attr = options[:data].merge(data_attr)
      end

      dropdown_output = dropdown_toggle(toggle_text, data_attr, options)

      if options.has_key?(:toggle_link)
        dropdown_output = dropdown_toggle_link(toggle_text, data_attr, options)
      end

      dropdown_output << content_tag(:div, class: "dropdown-menu dropdown-select #{options[:dropdown_class] if options.has_key?(:dropdown_class)}") do
        output = ""

        if options.has_key?(:title)
          output << dropdown_title(options[:title])
        end

        if options.has_key?(:filter)
          output << dropdown_filter(options[:placeholder])
        end

        output << content_tag(:div, class: "dropdown-content") do
          capture(&block) if block && !options.has_key?(:footer_content)
        end

        if block && options[:footer_content]
          output << content_tag(:div, class: "dropdown-footer") do
            capture(&block)
          end
        end

        output << dropdown_loading

        output.html_safe
      end

      dropdown_output.html_safe
    end
  end

  def dropdown_toggle(toggle_text, data_attr, options = {})
    content_tag(:button, class: "dropdown-menu-toggle #{options[:toggle_class] if options.has_key?(:toggle_class)}", id: (options[:id] if options.has_key?(:id)), type: "button", data: data_attr) do
      output = content_tag(:span, toggle_text, class: "dropdown-toggle-text")
      output << icon('chevron-down')
      output.html_safe
    end
  end

  def dropdown_toggle_link(toggle_text, data_attr, options = {})
    output = content_tag(:a, toggle_text, class: "dropdown-toggle-text #{options[:toggle_class] if options.has_key?(:toggle_class)}", id: (options[:id] if options.has_key?(:id)), data: data_attr)
    output.html_safe
  end

  def dropdown_title(title, back: false)
    content_tag :div, class: "dropdown-title" do
      title_output = ""

      if back
        title_output << content_tag(:button, class: "dropdown-title-button dropdown-menu-back", aria: { label: "Go back" }, type: "button") do
          icon('arrow-left')
        end
      end

      title_output << content_tag(:span, title)

      title_output << content_tag(:button, class: "dropdown-title-button dropdown-menu-close", aria: { label: "Close" }, type: "button") do
        icon('times', class: 'dropdown-menu-close-icon')
      end

      title_output.html_safe
    end
  end

  def dropdown_filter(placeholder, search_id: nil)
    content_tag :div, class: "dropdown-input" do
      filter_output = search_field_tag search_id, nil, class: "dropdown-input-field", placeholder: placeholder, autocomplete: 'off'
      filter_output << icon('search', class: "dropdown-input-search")
      filter_output << icon('times', class: "dropdown-input-clear js-dropdown-input-clear", role: "button")

      filter_output.html_safe
    end
  end

  def dropdown_content(&block)
    content_tag(:div, class: "dropdown-content") do
      if block
        capture(&block)
      end
    end
  end

  def dropdown_footer(&block)
    content_tag(:div, class: "dropdown-footer") do
      if block
        capture(&block)
      end
    end
  end

  def dropdown_loading
    content_tag :div, class: "dropdown-loading" do
      icon('spinner spin')
    end
  end
end
