# frozen_string_literal: true

require 'spec_helper'

describe VulnerabilityFeedback::DestroyService, '#execute' do
  let(:group)   { create(:group) }
  let(:project) { create(:project, :public, :repository, namespace: group) }
  let(:user)    { create(:user) }
  let(:vulnerability_feedback) { create(:vulnerability_feedback, feedback_type, project: project)}

  before do
    group.add_developer(user)
  end

  subject { described_class.new(project, user, vulnerability_feedback).execute }

  context 'when feedback_type is dismissal' do
    let(:feedback_type) { :dismissal }

    it 'destroys the feedback' do
      subject

      expect { vulnerability_feedback.reload }.to raise_error ActiveRecord::RecordNotFound
    end

    context 'when user is not authorized' do
      let(:unauthorized_user) { create(:user) }

      it 'raise error if permission is denied' do
        expect { described_class.new(project, unauthorized_user, vulnerability_feedback).execute }
          .to raise_error(Gitlab::Access::AccessDeniedError)
      end
    end
  end

  context 'when feedback_type is issue' do
    let(:feedback_type) { :issue }

    it 'raise error as this type of feedback can not be destroyed' do
      expect { described_class.new(project, user, vulnerability_feedback).execute }
        .to raise_error(Gitlab::Access::AccessDeniedError)
    end
  end

  context 'when feedback_type is merge_request' do
    let(:feedback_type) { :merge_request }

    it 'raise error as this type of feedback can not be destroyed' do
      expect { described_class.new(project, user, vulnerability_feedback).execute }
        .to raise_error(Gitlab::Access::AccessDeniedError)
    end
  end
end
