# frozen_string_literal: true

require 'spec_helper'

describe Gitlab::Vulnerabilities::BaseVulnerability do
  let(:vulnerability) do
    described_class.new(
      title:       'title',
      description: 'desc',
      severity:    'high',
      confidence:  'low',
      solution:    'fix',
      identifiers: '42',
      links:       'link'
    )
  end

  where(:getter) do
    %w(title description severity confidence solution identifiers links)
  end

  with_them do
    it 'raises an error' do
      expect { vulnerability.public_send(getter) }.to raise_error(NotImplementedError)
    end
  end
end
