# frozen_string_literal: true
require 'spec_helper'

describe Gitlab::Auth::GroupSaml::MembershipEnforcer do
  let(:user) { create(:user) }
  let(:identity) { create(:group_saml_identity, user: user) }
  let(:group) { identity.saml_provider.group }

  before do
    allow_any_instance_of(SamlProvider).to receive(:enforced_sso?).and_return(true)
  end

  it 'allows adding the group member' do
    expect(described_class.new(group).can_add_user?(user)).to be_truthy
  end

  it 'does not add the group member' do
    non_saml_user = create(:user)

    expect(described_class.new(group).can_add_user?(non_saml_user)).to be_falsey
  end
end
