import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_issue_link.vue';
import mountComponent from 'spec/helpers/vue_mount_component_helper';

describe('Vulnerability Issue Link component', () => {
  const Component = Vue.extend(component);
  let vm;
  let props;

  beforeEach(() => {
    const issue = {
      issue_iid: 1,
      issue_url: 'https://gitlab.com',
    };
    const projectName = 'Project Name';
    props = { issue, projectName };
    vm = mountComponent(Component, props);
  });

  afterEach(() => {
    vm.$destroy();
  });

  it('should render the severity label', () => {
    expect(vm.$el.textContent).toContain(`${props.projectName}#${props.issue.issue_iid}`);
  });

  it('should link to the issue', () => {
    const link = vm.$el.querySelector('a');

    expect(link.href).toMatch(props.issue.issue_url);
  });
});
