import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_count.vue';
import mountComponent from 'spec/helpers/vue_mount_component_helper';

describe('Vulnerability Count', () => {
  const Component = Vue.extend(component);
  let vm;
  let props;

  beforeEach(() => {
    const severity = 'high';
    const count = 100;
    props = { severity, count };
    vm = mountComponent(Component, props);
  });

  afterEach(() => {
    vm.$destroy();
  });

  it('should render the severity label', () => {
    const header = vm.$el.querySelector('.vulnerability-count-header');

    expect(header.textContent.toLowerCase()).toMatch(props.severity);
  });

  it('should render the count', () => {
    const body = vm.$el.querySelector('.vulnerability-count-body');

    expect(body.textContent).toMatch(props.count.toString());
  });
});
