import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_count_list.vue';
import createStore from 'ee/security_dashboard/store';
import { mountComponentWithStore } from 'spec/helpers/vue_mount_component_helper';
import { resetStore } from '../helpers';
import mockData from '../store/vulnerabilities/data/mock_data_vulnerabilities_count.json';

describe('Vulnerability Count List', () => {
  const Component = Vue.extend(component);
  const store = createStore();
  let vm;

  beforeEach(() => {
    store.dispatch('vulnerabilities/receiveVulnerabilitiesCountSuccess', { data: mockData });
    vm = mountComponentWithStore(Component, { store });
  });

  afterEach(() => {
    vm.$destroy();
    resetStore(store);
  });

  it('should fetch the counts for each severity', () => {
    const firstCount = vm.$el.querySelector('.js-count');

    expect(firstCount.textContent).toContain('Critical');
    expect(firstCount.textContent).toContain(mockData.critical);
  });

  it('should render a counter for each severity', () => {
    expect(vm.$el.querySelectorAll('.js-count')).toHaveLength(vm.counts.length);
  });
});
