import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_chart_tooltip.vue';
import mountComponent from 'spec/helpers/vue_mount_component_helper';

describe('Vulnerability Chart Tooltip component', () => {
  const Component = Vue.extend(component);
  const props = {
    entries: [
      {
        dataIndex: 1,
        seriesId: 'critical_0',
        seriesName: 'critical',
        color: '#00f',
        data: ['critical', 32],
      },
      {
        dataIndex: 1,
        seriesId: 'high_0',
        seriesName: 'high',
        color: '#0f0',
        data: ['high', 22],
      },
      {
        dataIndex: 1,
        seriesId: 'low_0',
        seriesName: 'low',
        color: '#f00',
        data: ['low', 2],
      },
    ],
  };
  let vm;

  beforeEach(() => {
    vm = mountComponent(Component, props);
  });

  afterEach(() => {
    vm.$destroy();
  });

  it('should render three legends', () => {
    const legends = vm.$el.querySelectorAll('.js-chart-label');

    expect(legends).toHaveLength(3);
  });
});
