import Vue from 'vue';
import MockAdapter from 'axios-mock-adapter';
import axios from '~/lib/utils/axios_utils';

import component from 'ee/security_dashboard/components/vulnerability_chart.vue';
import createStore from 'ee/security_dashboard/store';
import { mount } from '@vue/test-utils';

import { resetStore } from '../helpers';
import mockDataVulnerabilitiesHistory from '../store/vulnerabilities/data/mock_data_vulnerabilities_history.json';

describe('Vulnerabilities Chart', () => {
  const Component = Vue.extend(component);
  const vulnerabilitiesHistoryEndpoint = '/vulnerabilitiesEndpoint.json';
  let store;
  let mock;
  let wrapper;

  beforeEach(() => {
    store = createStore();
    store.state.vulnerabilities.vulnerabilitiesHistoryEndpoint = vulnerabilitiesHistoryEndpoint;
    mock = new MockAdapter(axios);
    mock.onGet(vulnerabilitiesHistoryEndpoint).replyOnce(200, mockDataVulnerabilitiesHistory);
    wrapper = mount(Component, { store, sync: false });
  });

  afterEach(() => {
    resetStore(store);
    wrapper.destroy();
    mock.restore();
  });

  it('should render the e-chart instance', done => {
    Vue.nextTick()
      .then(() => {
        expect(wrapper.find('[_echarts_instance_]')).not.toBeNull();
        done();
      })
      .catch(done.fail);
  });
});
