import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_chart_label.vue';
import mountComponent from 'spec/helpers/vue_mount_component_helper';

function hexToRgb(hex) {
  const cleanHex = hex.replace('#', '');
  const [r, g, b] = [
    cleanHex.substring(0, 2),
    cleanHex.substring(2, 4),
    cleanHex.substring(4, 6),
  ].map(rgb => parseInt(rgb, 16));

  return `rgb(${r}, ${g}, ${b})`;
}

describe('Vulnerability Chart Label component', () => {
  const Component = Vue.extend(component);
  let vm;
  const props = {
    name: 'Chuck Norris',
    color: '#BADA55',
    value: 42,
  };

  describe('default', () => {
    beforeEach(() => {
      vm = mountComponent(Component, props);
    });

    afterEach(() => {
      vm.$destroy();
    });

    it('should render the name', () => {
      const name = vm.$el.querySelector('.js-name');

      expect(name.textContent).toContain(props.name);
    });

    it('should render the value', () => {
      const value = vm.$el.querySelector('.js-value');

      expect(value.textContent).toContain(props.value);
    });

    it('should render the color', () => {
      const color = vm.$el.querySelector('.js-color');

      expect(color.style.backgroundColor).toBe(hexToRgb(props.color));
    });
  });

  describe('when the value is 0', () => {
    const newProps = { ...props, value: 0 };

    beforeEach(() => {
      vm = mountComponent(Component, newProps);
    });

    afterEach(() => {
      vm.$destroy();
    });

    it('should still render the value, but show a "0"', () => {
      const value = vm.$el.querySelector('.js-value');

      expect(value.textContent).toContain(newProps.value);
    });
  });
});
