import Vue from 'vue';
import component from 'ee/security_dashboard/components/vulnerability_chart_buttons.vue';
import { DAYS } from 'ee/security_dashboard/store/modules/vulnerabilities/constants';
import { shallowMount, mount } from '@vue/test-utils';

describe('Vulnerability Chart Buttons', () => {
  const Component = Vue.extend(component);
  const days = [DAYS.THIRTY, DAYS.SIXTY, DAYS.NINETY];

  describe('when rendering the buttons', () => {
    it('should render with 90 days selected', () => {
      const activeDay = DAYS.NINETY;
      const wrapper = shallowMount(Component, { propsData: { days, activeDay } });
      const activeButton = wrapper.find('[data-days="90"].active');

      expect(activeButton.attributes('data-days')).toMatch('90');
    });

    it('should render with 60 days selected', () => {
      const activeDay = DAYS.SIXTY;
      const wrapper = shallowMount(Component, { propsData: { days, activeDay } });
      const activeButton = wrapper.find('[data-days="60"].active');

      expect(activeButton.attributes('data-days')).toMatch('60');
    });

    it('should render with 30 days selected', () => {
      const activeDay = DAYS.THIRTY;
      const wrapper = shallowMount(Component, { propsData: { days, activeDay } });
      const activeButton = wrapper.find('[data-days="30"].active');

      expect(activeButton.attributes('data-days')).toMatch('30');
    });
  });

  describe('when clicking the button', () => {
    const activeDay = DAYS.THIRTY;
    let wrapper;

    beforeEach(() => {
      wrapper = mount(Component, { propsData: { days, activeDay }, sync: false });
    });

    it('should call the clickHandler', () => {
      spyOn(wrapper.vm, 'clickHandler').and.stub();
      wrapper.find('[data-days="30"].active').trigger('click', DAYS.THIRTY);

      expect(wrapper.vm.clickHandler).toHaveBeenCalledWith(DAYS.THIRTY);
    });

    it('should emit a click event', () => {
      wrapper.find('[data-days="30"].active').trigger('click', DAYS.THIRTY);

      expect(wrapper.emitted().click[0]).toEqual([DAYS.THIRTY]);
    });
  });
});
