import { createLocalVue, shallowMount } from '@vue/test-utils';
import { GlLink } from '@gitlab/ui';
import {
  OPTIONAL,
  OPTIONAL_CAN_APPROVE,
} from 'ee/vue_merge_request_widget/components/approvals/messages';
import ApprovalsSummaryOptional from 'ee/vue_merge_request_widget/components/approvals/approvals_summary_optional.vue';

const localVue = createLocalVue();

const TEST_HELP_PATH = 'help/path';

describe('EE MRWidget approvals summary optional', () => {
  let wrapper;

  const createComponent = (props = {}) => {
    wrapper = shallowMount(localVue.extend(ApprovalsSummaryOptional), {
      propsData: props,
      sync: false,
      localVue,
    });
  };

  afterEach(() => {
    wrapper.destroy();
    wrapper = null;
  });

  const findHelpLink = () => wrapper.find(GlLink);

  describe('when can approve', () => {
    beforeEach(() => {
      createComponent({ canApprove: true, helpPath: TEST_HELP_PATH });
    });

    it('shows optional can approve message', () => {
      expect(wrapper.text()).toEqual(OPTIONAL_CAN_APPROVE);
    });

    it('shows help link', () => {
      const link = findHelpLink();

      expect(link.exists()).toBe(true);
      expect(link.attributes('href')).toBe(TEST_HELP_PATH);
    });
  });

  describe('when cannot approve', () => {
    beforeEach(() => {
      createComponent({ canApprove: false, helpPath: TEST_HELP_PATH });
    });

    it('shows optional message', () => {
      expect(wrapper.text()).toEqual(OPTIONAL);
    });

    it('does not show help link', () => {
      expect(findHelpLink().exists()).toBe(false);
    });
  });
});
