import { createLocalVue, shallowMount } from '@vue/test-utils';
import DependencyVulnerability from 'ee/dependencies/components/dependency_vulnerability.vue';
import SeverityBadge from 'ee/vue_shared/security_reports/components/severity_badge.vue';
import mockDataVulnerabilities from '../../../javascripts/security_dashboard/store/vulnerabilities/data/mock_data_vulnerabilities.json';

describe('DependencyVulnerability component', () => {
  let wrapper;

  const factory = ({ propsData, ...options } = {}) => {
    const localVue = createLocalVue();

    wrapper = shallowMount(localVue.extend(DependencyVulnerability), {
      ...options,
      localVue,
      sync: false,
      propsData: { ...propsData },
    });
  };

  afterEach(() => {
    wrapper.destroy();
  });

  describe('given an vulnerability', () => {
    const vulnerability = mockDataVulnerabilities[0];
    beforeEach(() => {
      factory({
        propsData: {
          vulnerability,
        },
      });
    });

    it('matches the snapshot', () => {
      expect(wrapper.element).toMatchSnapshot();
    });

    it('renders the severity badge with the correct props', () => {
      const badge = wrapper.find(SeverityBadge);
      expect(badge.isVisible()).toBe(true);
      expect(badge.props().severity).toEqual(vulnerability.severity);
    });
  });
});
