# frozen_string_literal: true
require 'rails_helper'

describe 'Kerberos clone instructions', :js do
  include MobileHelpers

  let(:project) { create(:project, :empty_repo) }
  let(:admin) { create(:admin) }

  before do
    sign_in(admin)

    allow(Gitlab.config.kerberos).to receive(:enabled).and_return(true)
  end

  it 'shows Kerberos clone url' do
    visit_project

    find('.clone-dropdown-btn').click

    expect(page).to have_content(project.kerberos_url_to_repo)

    within('.git-clone-holder') do
      expect(page).to have_content('Clone with KRB5')
    end
  end

  context 'mobile component' do
    it 'shows the Kerberos clone information' do
      resize_screen_xs
      visit_project
      find('.dropdown-toggle').click

      expect(page).to have_content('Copy KRB5 clone URL')
    end
  end

  def visit_project
    visit project_path(project)
  end
end
