require 'logger'

desc "GitLab | Migrate packages files to remote storage"
namespace :gitlab do
  namespace :packages do
    task migrate: :environment do
      logger = Logger.new(STDOUT)
      logger.info('Starting transfer of package files to object storage')

      unless ::Packages::PackageFileUploader.object_store_enabled?
        raise 'Object store is disabled for packages feature'
      end

      ::Packages::PackageFile.with_files_stored_locally.find_each(batch_size: 10) do |package_file|
        package_file.file.migrate!(::Packages::PackageFileUploader::Store::REMOTE)

        logger.info("Transferred package file #{package_file.id} of size #{package_file.size.to_i.bytes} to object storage")
      rescue => e
        logger.error("Failed to transfer package file #{package_file.id} with error: #{e.message}")
      end
    end
  end
end
