# frozen_string_literal: true

module Gitlab
  module Vulnerabilities
    class StandardVulnerability < BaseVulnerability
      # Passthrough properties
      %i[
        severity
        confidence
        solution
        identifiers
        links
        remediations
        target_branch
      ].each do |method_name|
        define_method(method_name) do
          @data[method_name]
        end
      end

      def title
        @data[:title].presence || @data[:name]
      end

      def description
        @data[:description].presence || title
      end

      def file
        @data[:file].presence || @data.dig(:location, :file)
      end

      def line
        @data[:line].presence || @data.dig(:location, :start_line)
      end

      def location_text
        return file unless line

        "#{file}:#{line}"
      end

      def location_link
        return file unless line

        "#{file}#L#{line}"
      end
    end
  end
end
