# frozen_string_literal: true

module Gitlab
  module Vulnerabilities
    class BaseVulnerability
      attr_reader :data

      def initialize(data)
        @data = data
      end

      # Ensure mandatory properties are defined
      %i[
        title
        description
        severity
        confidence
        solution
        identifiers
        links
      ].each do |method_name|
        define_method(method_name) do
          raise NotImplementedError
        end
      end
    end
  end
end
