# frozen_string_literal: true

module VulnerabilityFeedback
  class DestroyService < ::BaseService
    def initialize(project, user, vulnerability_feedback)
      @project, @current_user, @vulnerability_feedback = project, user, vulnerability_feedback
    end

    def execute
      # TODO: Add system note when destroying a dismissal feedback
      raise Gitlab::Access::AccessDeniedError unless can?(current_user, :destroy_vulnerability_feedback, @vulnerability_feedback)

      @vulnerability_feedback.destroy
    end
  end
end
