---
comments: false
---

# Code review and collaboration with Merge Requests

- When you want feedback create a merge request
- Target is the default branch (usually master)
- Assign or mention the person you would like to review
- Add 'WIP' to the title if it's a work in progress
- When accepting, always delete the branch
- Anyone can comment, not just the assignee
- Push corrections to the same branch

## Merge requests

**Create your first merge request**

1. Use the blue button in the activity feed
1. View the diff (changes) and leave a comment
1. Push a new commit to the same branch
1. Review the changes again and notice the update

## Feedback and Collaboration

- Merge requests are a time for feedback and collaboration
- Giving feedback is hard
- Be as kind as possible
- Receiving feedback is hard
- Be as receptive as possible
- Feedback is about the best code, not the person. You are not your code

## Feedback and Collaboration

Review the Thoughtbot code-review guide for suggestions to follow when reviewing merge requests:
[https://github.com/thoughtbot/guides/tree/master/code-review](https://github.com/thoughtbot/guides/tree/master/code-review)

See GitLab merge requests for examples:
[https://gitlab.com/gitlab-org/gitlab-ce/merge_requests](https://gitlab.com/gitlab-org/gitlab-ce/merge_requests)
