module Gitlab
  module Vulnerabilities
    class StandardVulnerability < BaseVulnerability
      # Passthrough properties
      %i[
        title
        severity
        confidence
        solution
        identifiers
        links
      ].each do |method_name|
        define_method(method_name) do
          @data[method_name]
        end
      end

      def description
        @data[:description].presence || @data[:title]
      end
    end
  end
end
