module Gitlab
  module Vulnerabilities
    class ContainerScanningVulnerability < BaseVulnerability
      def title
        "#{@data[:vulnerability]} in #{@data[:namespace]}"
      end

      # Passthrough properties
      %i[
        confidence
        severity
        identifiers
        links
      ].each do |method_name|
        define_method(method_name) do
          @data[method_name]
        end
      end

      def description
        @data[:description].presence ||
          "**#{@data[:namespace]}** is affected by #{@data[:vulnerability]}"
      end

      def solution
        if @data[:fixedby].present? &&
            @data[:featurename].present? &&
            @data[:featureversion].present?

          "Upgrade **#{@data[:featurename]}** from `#{@data[:featureversion]}` to `#{@data[:fixedby]}`"
        end
      end
    end
  end
end
