class CreateVulnerabilityFeedback < ActiveRecord::Migration
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  def change
    create_table :vulnerability_feedback do |t|
      t.timestamps_with_timezone null: false

      t.integer :feedback_type, limit: 2, null: false
      t.integer :category, limit: 2, null: false

      t.references :project, null: false, foreign_key: { on_delete: :cascade }
      t.integer :author_id, null: false
      t.foreign_key :users, column: :author_id, on_delete: :cascade
      t.integer :pipeline_id
      t.foreign_key :ci_pipelines, column: :pipeline_id, on_delete: :nullify
      t.references :issue, null: true, index: true, foreign_key: { on_delete: :nullify }

      t.string :project_fingerprint, limit: 40, null: false

      t.index :author_id
      t.index :pipeline_id
      t.index [:project_id, :category, :feedback_type, :project_fingerprint], unique: true, name: 'vulnerability_feedback_unique_idx'
    end
  end
end
