# From Community Edition 11.2 to Enterprise Edition 11.2

This guide assumes you have a correctly configured and tested installation of
GitLab Community Edition 11.2. If you run into any trouble or if you have any
questions please contact us at [support@gitlab.com].

### 0. Backup

Make a backup just in case something goes wrong:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

For installations using MySQL, this may require granting "LOCK TABLES"
privileges to the GitLab user on the database version.

### 1. Stop server

```bash
sudo service gitlab stop
```

### 2. Get the EE code

```bash
cd /home/git/gitlab
sudo -u git -H git remote add -f ee https://gitlab.com/gitlab-org/gitlab-ee.git
sudo -u git -H git checkout 11-2-stable-ee
```

### 3. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without postgres')
sudo -u git -H bundle install --without postgres development test --deployment

# PostgreSQL installations (note: the line below states '--without mysql')
sudo -u git -H bundle install --without mysql development test --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production
```

### 4. Start application

```bash
sudo service gitlab start
sudo service nginx restart
```

### 5. Check application status

Check if GitLab and its environment are configured correctly:

```bash
sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production
```

To make sure you didn't miss anything run a more thorough check with:

```bash
sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production
```

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (Community Edition 11.1)

### 1. Revert the code to the previous version

```bash
cd /home/git/gitlab
sudo -u git -H git checkout 11-2-stable
```

### 2. Restore from the backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```

[support@gitlab.com]: mailto:support@gitlab.com
