# Application settings API

These API calls allow you to read and modify GitLab instance application
settings as appear in `/admin/application_settings`. You have to be an
administrator in order to perform this action.

## Get current application settings

List the current application settings of the GitLab instance.

```
GET /application/settings
```

```bash
curl --header "PRIVATE-TOKEN: 9koXpg98eAheJpvBs5tK" https://gitlab.example.com/api/v4/application/settings
```

Example response:

```json
{
   "default_projects_limit" : 100000,
   "signup_enabled" : true,
   "id" : 1,
   "default_branch_protection" : 2,
   "restricted_visibility_levels" : [],
   "password_authentication_enabled_for_web" : true,
   "after_sign_out_path" : null,
   "max_attachment_size" : 10,
   "user_oauth_applications" : true,
   "updated_at" : "2016-01-04T15:44:55.176Z",
   "session_expire_delay" : 10080,
   "home_page_url" : null,
   "default_snippet_visibility" : "private",
   "domain_whitelist" : [],
   "domain_blacklist_enabled" : false,
   "domain_blacklist" : [],
   "created_at" : "2016-01-04T15:44:55.176Z",
   "default_project_visibility" : "private",
   "default_group_visibility" : "private",
   "gravatar_enabled" : true,
   "sign_in_text" : null,
   "container_registry_token_expire_delay": 5,
   "repository_storages": ["default"],
   "koding_enabled": false,
   "koding_url": null,
   "plantuml_enabled": false,
   "plantuml_url": null,
   "terminal_max_session_time": 0,
   "polling_interval_multiplier": 1.0,
   "rsa_key_restriction": 0,
   "dsa_key_restriction": 0,
   "ecdsa_key_restriction": 0,
   "ed25519_key_restriction": 0,
   "enforce_terms": true,
   "terms": "Hello world!",
   "performance_bar_allowed_group_id": 42,
   "instance_statistics_visibility_private": false
}
```

## Change application settings

```
PUT /application/settings
```

| Attribute | Type | Required | Description |
| --------- | ---- | :------: | ----------- |
| `admin_notification_email`               | string           | no                                            | Abuse reports will be sent to this address if it is set. Abuse reports are always available in the admin area.                                                                                                                                                                                                                                                                                                                                            |
| `after_sign_out_path`                    | string           | no                                            | Where to redirect users after logout                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `after_sign_up_text`                     | string           | no                                            | Text shown to the user after signing up                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `akismet_api_key`                        | string           | no                                            | API key for akismet spam protection                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `akismet_enabled`                        | boolean          | no                                            | Enable or disable akismet spam protection                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `allow_group_owners_to_manage_ldap`      | boolean          | no                                            | Set to `true` to allow group owners to manage LDAP                                                                                                                                                                                                                                                                                                                                                                                                        |
| `authorized_keys_enabled`                | boolean          | no                                            | By default, we write to the "authorized_keys" file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.                                                                                                                                                                       |
| `circuitbreaker_access_retries           | integer          | no                                            | The number of attempts GitLab will make to access a storage.                                                                                                                                                                                                                                                                                                                                                                                              |
| `circuitbreaker_check_interval`          | integer          | no                                            | Number of seconds in between storage checks.                                                                                                                                                                                                                                                                                                                                                                                                              |
| `circuitbreaker_failure_count_threshold` | integer          | no                                            | The number of failures of after which GitLab will completely prevent access to the storage.                                                                                                                                                                                                                                                                                                                                                               |
| `circuitbreaker_failure_reset_time`      | integer          | no                                            | Time in seconds GitLab will keep storage failure information. When no failures occur during this time, the failure information is reset.                                                                                                                                                                                                                                                                                                                  |
| `circuitbreaker_storage_timeout`         | integer          | no                                            | Seconds to wait for a storage access attempt                                                                                                                                                                                                                                                                                                                                                                                                              |
| `clientside_sentry_dsn`                  | string           | no                                            | Required if `clientside_sentry_dsn` is enabled                                                                                                                                                                                                                                                                                                                                                                                                            |
| `clientside_sentry_enabled`              | boolean          | no                                            | Enable Sentry error reporting for the client side                                                                                                                                                                                                                                                                                                                                                                                                         |
| `container_registry_token_expire_delay`  | integer          | no                                            | Container Registry token duration in minutes                                                                                                                                                                                                                                                                                                                                                                                                              |
| `default_artifacts_expire_in`            | string           | no                                            | Set the default expiration time for each job's artifacts                                                                                                                                                                                                                                                                                                                                                                                                  |
| `default_branch_protection`              | integer          | no                                            | Determine if developers can push to master. Can take `0` _(not protected, both developers and maintainers can push new commits, force push, or delete the branch)_, `1` _(partially protected, developers and maintainers can push new commits, but cannot force push or delete the branch)_ or `2` _(fully protected, developers cannot push new commits, but maintainers can; no-one can force push or delete the branch)_ as a parameter. Default is `2`. |
| `default_group_visibility`               | string           | no                                            | What visibility level new groups receive. Can take `private`, `internal` and `public` as a parameter. Default is `private`.                                                                                                                                                                                                                                                                                                                               |
| `default_project_visibility`             | string           | no                                            | What visibility level new projects receive. Can take `private`, `internal` and `public` as a parameter. Default is `private`.                                                                                                                                                                                                                                                                                                                             |
| `default_projects_limit`                 | integer          | no                                            | Project limit per user. Default is `100000`                                                                                                                                                                                                                                                                                                                                                                                                               |
| `default_snippet_visibility`             | string           | no                                            | What visibility level new snippets receive. Can take `private`, `internal` and `public` as a parameter. Default is `private`.                                                                                                                                                                                                                                                                                                                             |
| `disabled_oauth_sign_in_sources`         | Array of strings | no                                            | Disabled OAuth sign-in sources                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `domain_blacklist_enabled`               | boolean          | no                                            | Enable/disable the `domain_blacklist`                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `domain_blacklist`                       | array of strings | yes (if `domain_blacklist_enabled` is `true`) | People trying to sign-up with emails from this domain will not be allowed to do so.                                                                                                                                                                                                                                                                                                                                                                       |
| `domain_whitelist`                       | array of strings | no                                            | Force people to use only corporate emails for sign-up. Default is null, meaning there is no restriction.                                                                                                                                                                                                                                                                                                                                                  |
| `dsa_key_restriction`                    | integer          | no                                            | The minimum allowed bit length of an uploaded DSA key. Default is `0` (no restriction). `-1` disables DSA keys.                                                                                                                                                                                                                                                                                                                                           |
| `ecdsa_key_restriction`                  | integer          | no                                            | The minimum allowed curve size (in bits) of an uploaded ECDSA key. Default is `0` (no restriction). `-1` disables ECDSA keys.                                                                                                                                                                                                                                                                                                                             |
| `ed25519_key_restriction`                | integer          | no                                            | The minimum allowed curve size (in bits) of an uploaded ED25519 key. Default is `0` (no restriction). `-1` disables ED25519 keys.                                                                                                                                                                                                                                                                                                                         |
| `elasticsearch_aws_access_key`           | string           | no                                            | AWS IAM access key                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `elasticsearch_aws_region`               | string           | no                                            | The AWS region the elasticsearch domain is configured                                                                                                                                                                                                                                                                                                                                                                                                     |
| `elasticsearch_aws_secret_access_key`    | string           | no                                            | AWS IAM secret access key                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `elasticsearch_aws`                      | boolean          | no                                            | Enable the use of AWS hosted Elasticsearch                                                                                                                                                                                                                                                                                                                                                                                                                |
| `elasticsearch_experimental_indexer`     | boolean          | no                                            | Use the beta elasticsearch indexer. More info: https://gitlab.com/gitlab-org/gitlab-elasticsearch-indexer                                                                                                                                                                                                                                                                                                                                         |
| `elasticsearch_indexing`                 | boolean          | no                                            | Enable Elasticsearch indexing                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `elasticsearch_search`                   | boolean          | no                                            | Enable Elasticsearch search                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `elasticsearch_url`                      | string           | no                                            | The url to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (e.g., "http://localhost:9200, http://localhost:9201")                                                                                                                                                                                                                                                                                                      |
| `email_author_in_body`                   | boolean          | no                                            | Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.                                                                                                                                                                                                                                                                |
| `email_additional_text`                   | string          | no                                            | **(Premium)** Additional text added to the bottom of every email for legal/auditing/compliance reasons reasons                                                                                                                                                                                                                                                                |
| `enabled_git_access_protocol`            | string           | no                                            | Enabled protocols for Git access. Allowed values are: `ssh`, `http`, and `nil` to allow both protocols.                                                                                                                                                                                                                                                                                                                                                   |
| `geo_status_timeout`                     | integer          | no                                            | The amount of seconds after which a request to get a secondary node status will time out.                                                                                                                                                                                                                                                                                                                                                                 |
| `gravatar_enabled`                       | boolean          | no                                            | Enable Gravatar                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `help_page_hide_commercial_content`      | boolean          | no                                            | Hide marketing-related entries from help                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `help_page_support_url`                  | string           | no                                            | Alternate support URL for help page                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `help_text`                              | string           | no                                            | GitLab server administrator information
| `home_page_url`                          | string           | no                                            | Redirect to this URL when not logged in                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `housekeeping_bitmaps_enabled`           | boolean          | no                                            | Enable Git pack file bitmap creation                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `housekeeping_enabled`                   | boolean          | no                                            | Enable or disable git housekeeping                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `housekeeping_full_repack_period`        | integer          | no                                            | Number of Git pushes after which an incremental 'git repack' is run.                                                                                                                                                                                                                                                                                                                                                                                      |
| `housekeeping_gc_period`                 | integer          | no                                            | Number of Git pushes after which 'git gc' is run.                                                                                                                                                                                                                                                                                                                                                                                                         |
| `housekeeping_incremental_repack_period` | integer          | no                                            | Number of Git pushes after which an incremental 'git repack' is run.                                                                                                                                                                                                                                                                                                                                                                                      |
| `html_emails_enabled`                    | boolean          | no                                            | Enable HTML emails                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `import_sources`                         | Array of strings | no                                            | Sources to allow project import from, possible values: "github bitbucket gitlab google_code fogbugz git gitlab_project manifest                                                                                                                                                                                                                                                                                                                           |
| `koding_enabled`                         | boolean          | no                                            | Enable Koding integration. Default is `false`.                                                                                                                                                                                                                                                                                                                                                                                                            |
| `koding_url`                             | string           | yes (if `koding_enabled` is `true`)           | The Koding instance URL for integration.                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `max_artifacts_size`                     | integer          | no                                            | Maximum artifacts size in MB                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `max_attachment_size`                    | integer          | no                                            | Limit attachment size in MB                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `max_pages_size`                         | integer          | no                                            | Maximum size of pages repositories in MB                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `metrics_enabled`                        | boolean          | no                                            | Enable influxDB metrics                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `metrics_host`                           | string           | yes (if `metrics_enabled` is `true`)          | InfluxDB host                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `metrics_method_call_threshold`          | integer          | yes (if `metrics_enabled` is `true`)          | A method call is only tracked when it takes longer than the given amount of milliseconds                                                                                                                                                                                                                                                                                                                                                                  |
| `metrics_packet_size`                    | integer          | yes (if `metrics_enabled` is `true`)          | The amount of datapoints to send in a single UDP packet.                                                                                                                                                                                                                                                                                                                                                                                                  |
| `metrics_pool_size`                      | integer          | yes (if `metrics_enabled` is `true`)          | The amount of InfluxDB connections to keep open                                                                                                                                                                                                                                                                                                                                                                                                           |
| `metrics_port`                           | integer          | no                                            | The UDP port to use for connecting to InfluxDB                                                                                                                                                                                                                                                                                                                                                                                                            |
| `metrics_sample_interval`                | integer          | yes (if `metrics_enabled` is `true`)          | The sampling interval in seconds.                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `metrics_timeout`                        | integer          | yes (if `metrics_enabled` is `true`)          | The amount of seconds after which InfluxDB will time out.                                                                                                                                                                                                                                                                                                                                                                                                 |
| `password_authentication_enabled_for_web` | boolean         | no                                            | Enable authentication for the web interface via a GitLab account password. Default is `true`.                                                                                                                                                                                                                                                                                                                                                                                   |
| `password_authentication_enabled_for_git` | boolean         | no                                            | Enable authentication for Git over HTTP(S) via a GitLab account password. Default is `true`.                                                                                                                                                                                                                                                                                                                                                                                   |
| `performance_bar_allowed_group_path`      | string          | no                                            | Path of the group that is allowed to toggle the performance bar                                                                                                                                                                                                                                                                                                                                                                                                   |
| `performance_bar_allowed_group_id`       | string           | no                                            | Deprecated: Use `performance_bar_allowed_group_path` instead. Path of the group that is allowed to toggle the performance bar                                                                                                                                                                                                                                                                                                                                                                                                   |
| `performance_bar_enabled`                | boolean          | no                                            | Deprecated: Pass `performance_bar_allowed_group_path: nil` instead. Allow enabling the performance bar                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `plantuml_enabled`                       | boolean          | no                                            | Enable PlantUML integration. Default is `false`.                                                                                                                                                                                                                                                                                                                                                                                                          |
| `plantuml_url`                           | string           | yes (if `plantuml_enabled` is `true`)         | The PlantUML instance URL for integration.                                                                                                                                                                                                                                                                                                                                                                                                                |
| `polling_interval_multiplier`            | decimal          | no                                            | Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.                                                                                                                                                                                                                                                                                                                                                                  |
| `project_export_enabled`                 | boolean          | no                                            | Enable project export                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `prometheus_metrics_enabled`             | boolean          | no                                            | Enable prometheus metrics                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `recaptcha_enabled`                      | boolean          | no                                            | Enable recaptcha                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `recaptcha_private_key`                  | string           | yes (if `recaptcha_enabled` is true)          | Private key for recaptcha                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `recaptcha_site_key`                     | string           | yes (if `recaptcha_enabled` is true)          | Site key for recaptcha                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `repository_checks_enabled`              | boolean          | no                                            | GitLab will periodically run 'git fsck' in all project and wiki repositories to look for silent disk corruption issues.                                                                                                                                                                                                                                                                                                                                   |
| `repository_size_limit`                  | integer          | no                                            | Size limit per repository (MB)                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `repository_storages`                    | array of strings | no                                            | A list of names of enabled storage paths, taken from `gitlab.yml`. New projects will be created in one of these stores, chosen at random.                                                                                                                                                                                                                                                                                                                 |
| `require_two_factor_authentication`      | boolean          | no                                            | Require all users to setup Two-factor authentication                                                                                                                                                                                                                                                                                                                                                                                                      |
| `restricted_visibility_levels`           | array of strings | no                                            | Selected levels cannot be used by non-admin users for groups, projects or snippets. Can take `private`, `internal` and `public` as a parameter. Default is null which means there is no restriction.                                                                                                                                                                                                                                                              |
| `rsa_key_restriction`                    | integer          | no                                            | The minimum allowed bit length of an uploaded RSA key. Default is `0` (no restriction). `-1` disables RSA keys.                                                                                                                                                                                                                                                                                                                                           |
| `send_user_confirmation_email`           | boolean          | no                                            | Send confirmation email on sign-up                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `sentry_dsn`                             | string           | yes (if `sentry_enabled` is true)             | Sentry Data Source Name                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `sentry_enabled`                         | boolean          | no                                            | Sentry is an error reporting and logging tool which is currently not shipped with GitLab, get it here: https://getsentry.com                                                                                                                                                                                                                                                                                                                              |
| `session_expire_delay`                   | integer          | no                                            | Session duration in minutes. GitLab restart is required to apply changes                                                                                                                                                                                                                                                                                                                                                                                  |
| `shared_runners_enabled`                 | true             | no                                            | Enable shared runners for new projects                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `shared_runners_minutes`                 | integer          | yes (if `shared_runners_enabled` is true)     | Set the maximum number of pipeline minutes that a group can use on shared Runners per month.                                                                                                                                                                                                                    | `shared_runners_text`                    | string           | no                                            | Shared runners text                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `sidekiq_throttling_enabled`             | boolean          | no                                            | Enable Sidekiq Job Throttling                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `sidekiq_throttling_factor`              | decimal          | yes (if `sidekiq_throttling_enabled` is true) | The factor by which the queues should be throttled. A value between 0.0 and 1.0, exclusive.                                                                                                                                                                                                                                                                                                                                                               |
| `sidekiq_throttling_queues`              | array of strings | yes (if `sidekiq_throttling_enabled` is true) | Choose which queues you wish to throttle                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `sign_in_text`                           | string           | no                                            | Text on login page                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `signup_enabled`                         | boolean          | no                                            | Enable registration. Default is `true`.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `slack_app_enabled`                      | boolean          | no                                            | Enable Slack ap                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `slack_app_id`                           | string           | yes (if `slack_app_enabled` is true)          | The app id of the Slack-app                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `slack_app_secret`                       | string           | yes (if `slack_app_enabled` is true)          | The app secret of the Slack-app                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `slack_app_verification_token`           | string           | yes (if `slack_app_enabled` is true)          | The verification token of the Slack-app                                                                                                                                                                                                                                                                                                                              | `terminal_max_session_time`              | integer          | no                                            | Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.                                                                                                                                                                                                                                                                                                                                                             |
| `two_factor_grace_period`                | integer          | no                                            | Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication                                                                                                                                                                                                                                                                                                                                                |
| `unique_ips_limit_enabled`               | boolean          | no                                            | Limit sign in from multiple ips                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `unique_ips_limit_per_user`              | integer          | yes (if `unique_ips_limit_enabled` is true)   | Maximum number of ips per user                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `unique_ips_limit_time_window`           | integer          | yes (if `unique_ips_limit_enabled` is true)   | How many seconds an IP will be counted towards the limit                                                                                                                                                                                                                                                                                                                                                                                                  |
| `usage_ping_enabled`                     | boolean          | no                                            | Every week GitLab will report license usage back to GitLab, Inc.                                                                                                                                                                                                                                                                                                                                                                                          |
| `user_default_external`                  | boolean          | no                                            | Newly registered users will by default be external                                                                                                                                                                                                                                                                                                                                                                                                        |
| `user_oauth_applications`                | boolean          | no                                            | Allow users to register any application to use GitLab as an OAuth provider                                                                                                                                                                                                                                                                                                                                                                                |
| `version_check_enabled`                  | boolean          | no                                            | Let GitLab inform you when an update is available.                                                                                                                                                                                                                                                                                                                                                                                                        |
| `external_authorization_service_enabled` | boolean | no | Enable using an external authorization service for accessing projects |
| `external_authorization_service_url` | string | no | URL to which authorization requests will be directed |
| `external_authorization_service_default_label` | string | no | The default classification label to use when requesting authorization and no classification label has been specified on the project |
| `external_auth_client_cert` | string | no | The certificate to use to authenticate with the external authorization service |
| `external_auth_client_key` | string | no | Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored |
| `external_auth_client_key_pass` | string | no | Passphrase to use for the private key when authenticating with the external service this is encrypted when stored |
| `enforce_terms`                          | boolean          | no                                            | Enforce application ToS to all users                                                                                                                                                                                                                                                                                                                                                                                                         |
| `terms`                                  | text             | yes (if `enforce_terms` is true)              | Markdown content for the ToS                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `instance_statistics_visibility_private` | boolean          | no                                            | When set to `true` Instance statistics will only be available to admins                                                                                                                                                                                                                                                                                                                                                                      |

```bash
curl --request PUT --header "PRIVATE-TOKEN: 9koXpg98eAheJpvBs5tK" https://gitlab.example.com/api/v4/application/settings?signup_enabled=false&default_project_visibility=internal
```

Example response:

```json
{
  "id": 1,
  "default_projects_limit": 100000,
  "signup_enabled": true,
  "password_authentication_enabled_for_web": true,
  "gravatar_enabled": true,
  "sign_in_text": "",
  "created_at": "2015-06-12T15:51:55.432Z",
  "updated_at": "2015-06-30T13:22:42.210Z",
  "home_page_url": "",
  "default_branch_protection": 2,
  "restricted_visibility_levels": [],
  "max_attachment_size": 10,
  "session_expire_delay": 10080,
  "default_project_visibility": "internal",
  "default_snippet_visibility": "private",
  "default_group_visibility": "private",
  "domain_whitelist": [],
  "domain_blacklist_enabled" : false,
  "domain_blacklist" : [],
  "user_oauth_applications": true,
  "after_sign_out_path": "",
  "container_registry_token_expire_delay": 5,
  "repository_storages": ["default"],
  "koding_enabled": false,
  "koding_url": null,
  "plantuml_enabled": false,
  "plantuml_url": null,
  "terminal_max_session_time": 0,
  "polling_interval_multiplier": 1.0,
  "external_authorization_service_enabled": true,
  "external_authorization_service_url": "https://authorize.me",
  "external_authorization_service_default_label": "default",
  "external_authorization_service_timeout": 0.5,
  "rsa_key_restriction": 0,
  "dsa_key_restriction": 0,
  "ecdsa_key_restriction": 0,
  "ed25519_key_restriction": 0,
  "enforce_terms": true,
  "terms": "Hello world!",
  "performance_bar_allowed_group_id": 42,
  "instance_statistics_visibility_private": false
}
```
