# Updating the Geo nodes

Depending on which version of Geo you are updating to/from, there may be
different steps.

## General update steps

In order to update the Geo nodes when a new GitLab version is released,
all you need to do is update GitLab itself:

1. Log into each node (primary and secondaries)
1. [Update GitLab][update]
1. [Update tracking database on secondary node](#update-tracking-database-on-secondary-node) when
   the tracking database is enabled.
1. [Test](#check-status-after-updating) primary and secondary nodes, and check version in each.

## Upgrading to GitLab 10.8

Before 10.8, broadcast messages would not propagate without flushing the cache on the secondaries.
This has been fixed in 10.8, but requires one last cache flush on each secondary node:

```bash
sudo gitlab-rake cache:clear
```

## Upgrading to GitLab 10.6

In 10.4 we started to recommend that you define a password for database user (`gitlab`).

We now require this change as we use this password to enable the Foreign Data Wrapper, as a way to optimize
the Geo Tracking Database. We are also improving security by disabling the use of **trust**
authentication method.

1. **[primary]** Login to your primary node and run:

    ```bash
    gitlab-ctl pg-password-md5 gitlab
    # Enter password: mypassword
    # Confirm password: mypassword
    # fca0b89a972d69f00eb3ec98a5838484
    ```

    Copy the generated hash and edit `/etc/gitlab/gitlab.rb`:

    ```ruby
    # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab`
    postgresql['sql_user_password'] = 'fca0b89a972d69f00eb3ec98a5838484'

    # Every node that runs Unicorn or Sidekiq needs to have the database
    # password specified as below. If you have a high-availability setup, this
    # must be present in all application nodes.
    gitlab_rails['db_password'] = 'mypassword' ```

    Still in the configuration file, locate and remove the `trust_auth_cidr_address`:

    ```ruby
    postgresql['trust_auth_cidr_addresses'] = ['127.0.0.1/32','1.2.3.4/32'] # <- Remove this
    ```

1. **[primary]** Reconfigure and restart

    ```bash
    sudo gitlab-ctl reconfigure
    sudo gitlab-ctl restart
    ```

1. **[secondary]** Login to all secondary nodes and edit `/etc/gitlab/gitlab.rb`:

    ```ruby
    # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab`
    postgresql['sql_user_password'] = 'fca0b89a972d69f00eb3ec98a5838484'

    # Every node that runs Unicorn or Sidekiq needs to have the database
    # password specified as below. If you have a high-availability setup, this
    # must be present in all application nodes.
    gitlab_rails['db_password'] = 'mypassword'

    # Enable Foreign Data Wrapper
    geo_secondary['db_fdw'] = true

    # Secondary address
    # - replace '5.6.7.8' with the secondary public or VPC address
    postgresql['md5_auth_cidr_addresses'] = ['5.6.7.8/32']
    ```

    Still in the configuration file, locate and remove the `trust_auth_cidr_address`:

    ```ruby
    postgresql['trust_auth_cidr_addresses'] = ['127.0.0.1/32','5.6.7.8/32'] # <- Remove this
    ```

1. **[secondary]** Reconfigure and restart

    ```bash
    sudo gitlab-ctl reconfigure
    sudo gitlab-ctl restart
    ```

## Upgrading to GitLab 10.5

For Geo Disaster Recovery to work with minimum downtime, your Geo secondary
should use the same set of secrets as the primary. However, setup instructions
prior to the 10.5 release only synchronized the `db_key_base` secret.

To rectify this error on existing installations, you should **overwrite** the
contents of `/etc/gitlab/gitlab-secrets.json` on the secondary node with the
contents of `/etc/gitlab/gitlab-secrets.json` on the primary node, then run the
following command on the secondary node:

```bash
sudo gitlab-ctl reconfigure
```

If you do not perform this step, you may find that two-factor authentication
[is broken following DR](faq.md#i-followed-the-disaster-recovery-instructions-and-now-two-factor-auth-is-broken).

To prevent SSH requests to the newly promoted primary node from failing
due to SSH host key mismatch when updating the primary domain's DNS record
you should perform the step to [Manually replicate primary SSH host keys][configuration-replicate-ssh] in each
secondary node.

## Upgrading to GitLab 10.4

There are no Geo-specific steps to take!

## Upgrading to GitLab 10.3

### Support for SSH repository synchronization removed

In GitLab 10.2, synchronizing secondaries over SSH was deprecated. In 10.3,
support is removed entirely. All installations will switch to the HTTP/HTTPS
cloning method instead. Before upgrading, ensure that all your Geo nodes are
configured to use this method and that it works for your installation. In
particular, ensure that [Git access over HTTP/HTTPS is enabled][configuration-git-over-http].

Synchronizing repositories over the public Internet using HTTP is insecure, so
you should ensure that you have HTTPS configured before upgrading. Note that
file synchronization is **also** insecure in these cases!

## Upgrading to GitLab 10.2

### Secure PostgreSQL replication

Support for TLS-secured PostgreSQL replication has been added. If you are
currently using PostgreSQL replication across the open internet without an
external means of securing the connection (e.g., a site-to-site VPN), then you
should immediately reconfigure your primary and secondary PostgreSQL instances
according to the [updated instructions][database].

If you *are* securing the connections externally and wish to continue doing so,
ensure you include the new option `--sslmode=prefer` in future invocations of
`gitlab-ctl replicate-geo-database`.

### HTTPS repository sync

Support for replicating repositories and wikis over HTTP/HTTPS has been added.
Replicating over SSH has been deprecated, and support for this option will be
removed in a future release.

To switch to HTTP/HTTPS replication, log into the primary node as an admin and visit
**Admin Area ➔ Geo Nodes** (`/admin/geo_nodes`). For each secondary listed,
press the "Edit" button, change the "Repository cloning" setting from
"SSH (deprecated)" to "HTTP/HTTPS", and press "Save changes". This should take
effect immediately.

Any new secondaries should be created using HTTP/HTTPS replication - this is the
default setting.

After you've verified that HTTP/HTTPS replication is working, you should remove
the now-unused SSH keys from your secondaries, as they may cause problems if the
secondary if ever promoted to a primary:

1. **[secondary]** Login to **all** your secondary nodes and run:

    ```ruby
    sudo -u git -H rm ~git/.ssh/id_rsa ~git/.ssh/id_rsa.pub
    ```

### Hashed Storage

CAUTION: **Warning:**
Hashed storage is in **Alpha**. It is considered experimental and not
production-ready. See [Hashed Storage] for more detail.

If you previously enabled Hashed Storage and migrated all your existing
projects to Hashed Storage, disabling hashed storage will not migrate projects
to their previous project based storage path. As such, once enabled and
migrated we recommend leaving Hashed Storage enabled.

## Upgrading to GitLab 10.1

CAUTION: **Warning:**
Hashed storage is in **Alpha**. It is considered experimental and not
production-ready. See [Hashed Storage] for more detail.

[Hashed storage] was introduced in GitLab 10.0, and a [migration path][hashed-migration]
for existing repositories was added in GitLab 10.1.

## Upgrading to GitLab 10.0

Since GitLab 10.0, we require all **Geo** systems to [use SSH key lookups via
the database][ssh-fast-lookup] to avoid having to maintain consistency of the
`authorized_keys` file for SSH access. Failing to do this will prevent users
from being able to clone via SSH.

Note that in older versions of Geo, attachments downloaded on the secondary
nodes would be saved to the wrong directory. We recommend that you do the
following to clean this up.

On the SECONDARY Geo nodes, run as root:

```bash
mv /var/opt/gitlab/gitlab-rails/working /var/opt/gitlab/gitlab-rails/working.old
mkdir /var/opt/gitlab/gitlab-rails/working
chmod 700 /var/opt/gitlab/gitlab-rails/working
chown git:git /var/opt/gitlab/gitlab-rails/working
```

You may delete `/var/opt/gitlab/gitlab-rails/working.old` any time.

Once this is done, we advise restarting GitLab on the secondary nodes for the
new working directory to be used:

```bash
sudo gitlab-ctl restart
```

## Upgrading from GitLab 9.3 or older

If you started running Geo on GitLab 9.3 or older, we recommend that you
resync your secondary PostgreSQL databases to use replication slots. If you
started using Geo with GitLab 9.4 or 10.x, no further action should be
required because replication slots are used by default. However, if you
started with GitLab 9.3 and upgraded later, you should still follow the
instructions below.

When in doubt, it does not hurt to do a resync. The easiest way to do this in
Omnibus is the following:

  1. Make sure you have Omnibus GitLab on the primary server
  1. Run `gitlab-ctl reconfigure` and `gitlab-ctl restart postgresql`. This will enable replication slots on the primary database.
  1. Check the steps about defining `postgresql['sql_user_password']`, `gitlab_rails['db_password']`
  1. Make sure `postgresql['max_replication_slots']` matches the number of secondary Geo Nodes locations
  1. Install GitLab on the secondary server.
  1. Re-run the [database replication process][database-replication].

## Special update notes for 9.0.x

> **IMPORTANT**:
With GitLab 9.0, the PostgreSQL version is upgraded to 9.6 and manual steps are
required in order to update the secondary nodes and keep the Streaming
Replication working. Downtime is required, so plan ahead.

The following steps apply only if you upgrade from a 8.17 GitLab version to
9.0+. For previous versions, update to GitLab 8.17 first before attempting to
upgrade to 9.0+.

---

Make sure to follow the steps in the exact order as they appear below and pay
extra attention in what node (primary/secondary) you execute them! Each step
is prepended with the relevant node for better clarity:

1. **[secondary]** Login to **all** your secondary nodes and stop all services:

    ```ruby
    sudo gitlab-ctl stop
    ```

1. **[secondary]** Make a backup of the `recovery.conf` file on **all**
   secondary nodes to preserve PostgreSQL's credentials:

    ```bash
    sudo cp /var/opt/gitlab/postgresql/data/recovery.conf /var/opt/gitlab/
    ```

1. **[primary]** Update the primary node to GitLab 9.0 following the
   [regular update docs][update]. At the end of the update, the primary node
   will be running with PostgreSQL 9.6.

1. **[primary]** To prevent a de-synchronization of the repository replication,
   stop all services except `postgresql` as we will use it to re-initialize the
   secondary node's database:

    ```bash
    sudo gitlab-ctl stop
    sudo gitlab-ctl start postgresql
    ```

1. **[secondary]** Run the following steps on each of the secondaries:

    1. **[secondary]**  Stop all services:

        ```bash
        sudo gitlab-ctl stop
        ```

    1. **[secondary]** Prevent running database migrations:

        ```bash
        sudo touch /etc/gitlab/skip-auto-migrations
        ```

    1. **[secondary]** Move the old database to another directory:

        ```bash
        sudo mv /var/opt/gitlab/postgresql{,.bak}
        ```

    1. **[secondary]** Update to GitLab 9.0 following the [regular update docs][update].
       At the end of the update, the node will be running with PostgreSQL 9.6.

    1. **[secondary]** Make sure all services are up:

        ```bash
        sudo gitlab-ctl start
        ```

    1. **[secondary]** Reconfigure GitLab:

        ```bash
        sudo gitlab-ctl reconfigure
        ```

    1. **[secondary]** Run the PostgreSQL upgrade command:

        ```bash
        sudo gitlab-ctl pg-upgrade
        ```

    1. **[secondary]** See the stored credentials for the database that you will
       need to re-initialize the replication:

        ```bash
        sudo grep -s primary_conninfo /var/opt/gitlab/recovery.conf
        ```

    1. **[secondary]** Create the `replica.sh` script as described in the
       [database configuration document][database-source-replication].

    1. **[secondary]** Run the recovery script using the credentials from the
       previous step:

        ```bash
        sudo bash /tmp/replica.sh
        ```

    1. **[secondary]** Reconfigure GitLab:

        ```bash
        sudo gitlab-ctl reconfigure
        ```

    1. **[secondary]** Start all services:

        ```bash
        sudo gitlab-ctl start
        ```

    1. **[secondary]** Repeat the steps for the rest of the secondaries.

1. **[primary]** After all secondaries are updated, start all services in
   primary:

    ```bash
    sudo gitlab-ctl start
    ```

## Check status after updating

Now that the update process is complete, you may want to check whether
everything is working correctly:

1. Run the Geo raketask on all nodes, everything should be green:

    ```bash
    sudo gitlab-rake gitlab:geo:check
    ```

1. Check the primary's Geo dashboard for any errors
1. Test the data replication by pushing code to the primary and see if it
   is received by the secondaries

## Update tracking database on secondary node

After updating a secondary node, you might need to run migrations on
the tracking database. The tracking database was added in GitLab 9.1,
and it is required since 10.0.

1. Run database migrations on tracking database

    ```bash
    sudo gitlab-rake geo:db:migrate
    ```

1. Repeat this step for every secondary node

[update]: ../../../update/README.md
[database]: database.md
[database-replication]: database.md#step-3-initiate-the-replication-process
[database-source-replication]: database_source.md#step-3-initiate-the-replication-process
[Hashed Storage]: ../../repository_storage_types.md
[hashed-migration]: ../../raketasks/storage.md
[ssh-fast-lookup]: ../../operations/fast_ssh_key_lookup.md
[configuration-replicate-ssh]: configuration.md#step-2-manually-replicate-primary-ssh-host-keys
[configuration-git-over-http]: configuration.md#step-6-enable-git-access-over-http-https
