# frozen_string_literal: true

require 'spec_helper'

RSpec.describe GroupVulnerabilityAutocompleteEntity do
  let(:group) { build_stubbed(:group) }
  let(:project) { build_stubbed(:project, group: group) }
  let(:vulnerability) { build_stubbed(:vulnerability, project: project) }

  describe '#represent' do
    subject { described_class.new(vulnerability, parent_group: project).as_json }

    it 'includes the id, title, and reference' do
      expect(subject).to include(:id, :title, :reference)
    end
  end
end
