# frozen_string_literal: true

module EE
  module API
    module Entities
      class VulnerabilityExport < Grape::Entity
        include ::API::Helpers::RelatedResourcesHelpers

        expose :id
        expose :created_at
        expose :project_id
        expose :group_id
        expose :format
        expose :status
        expose :started_at
        expose :finished_at

        expose :_links do
          expose :self do |export|
            expose_url api_v4_security_vulnerability_exports_path(id: export.id)
          end

          expose :download do |export|
            expose_url api_v4_security_vulnerability_exports_download_path(id: export.id)
          end
        end
      end
    end
  end
end
