# frozen_string_literal: true

module VulnerabilityExports
  class ExportDeletionWorker
    include ApplicationWorker

    data_consistency :always

    sidekiq_options retry: 3

    feature_category :vulnerability_management

    idempotent!

    def perform(vulnerability_export_id)
      vulnerability_export = Vulnerabilities::Export.find_by_id(vulnerability_export_id)
      vulnerability_export&.destroy!
    end
  end
end
