# frozen_string_literal: true

module Security
  class VulnerabilityReportDataEntity < Grape::Entity
    include ::API::Helpers::RelatedResourcesHelpers
    include ::CommitsHelper

    expose :id, as: :pipeline_id
    expose :iid, as: :pipeline_iid
    expose :source_ref, as: :source_branch

    expose :empty_state_svg_path do |_|
      ActionController::Base.helpers.image_path('illustrations/user-not-logged-in.svg')
    end

    expose :project_id do |_, options|
      options[:project].id
    end

    expose :vulnerabilities_endpoint do |pipeline, options|
      expose_path(
        api_v4_projects_vulnerability_findings_path(
          id: options[:project].id, params: { pipeline_id: pipeline.id }
        )
      )
    end

    expose :pipeline_jobs_path do |pipeline, options|
      expose_path(
        api_v4_projects_pipelines_jobs_path(id: options[:project].id, pipeline_id: pipeline.id)
      )
    end

    expose :vulnerability_exports_endpoint do |pipeline, options|
      expose_path(
        api_v4_security_projects_vulnerability_exports_path(
          id: options[:project].id
        )
      )
    end

    expose :empty_state_unauthorized_svg_path do |_|
      ActionController::Base.helpers.image_path('illustrations/user-not-logged-in.svg')
    end

    expose :empty_state_forbidden_svg_path do |_|
      ActionController::Base.helpers.image_path('illustrations/lock_promotion.svg')
    end

    expose :project_full_path do |_, options|
      options[:project].path_with_namespace
    end

    expose :commit_path_template do |_, options|
      commit_path_template(options[:project])
    end

    expose :can_admin_vulnerability do |_, options|
      (options[:user].present? && options[:user].can?(:admin_vulnerability, options[:project])).to_s
    end

    expose :can_view_false_positive do |_, options|
      options[:project].licensed_feature_available?(:sast_fp_reduction).to_s
    end

    def project_commit_path(...)
      Rails.application.routes.url_helpers.project_commit_path(...)
    end
  end
end
