# frozen_string_literal: true

module Types
  class VulnerabilityScannerType < BaseObject
    graphql_name 'VulnerabilityScanner'
    description 'Represents a vulnerability scanner'

    present_using ::Vulnerabilities::ScannerPresenter

    authorize :read_vulnerability_scanner

    field :id, GraphQL::Types::ID,
      null: true, description: 'ID of the scanner.'

    field :name, GraphQL::Types::String,
      null: true, description: 'Name of the vulnerability scanner.'

    field :external_id, GraphQL::Types::String,
      null: true, description: 'External ID of the vulnerability scanner.'

    field :vendor, GraphQL::Types::String,
      null: true, description: 'Vendor of the vulnerability scanner.'

    field :report_type, VulnerabilityReportTypeEnum, null: true,
                                                     description: 'Type of the vulnerability report.'

    field :report_type_humanized, GraphQL::Types::String, null: true,
                                                          description: 'Humanized type of the vulnerability report.'
  end
end
