# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # rubocop: disable Graphql/AuthorizeTypes
    class GenericType < BaseObject
      graphql_name 'VulnerabilityLocationGeneric'
      description 'Represents the location of a vulnerability found by a generic scanner.'

      field :description, GraphQL::Types::String,
        null: true, description: 'Free-form description of where the vulnerability is located.'
    end
  end
end
