# frozen_string_literal: true
module Types
  class VulnerabilityIdentifierInputType < BaseInputObject
    argument :name, GraphQL::Types::String,
          description: 'Name of the vulnerability identifier.',
          required: true

    argument :url, GraphQL::Types::String,
          description: 'URL of the vulnerability identifier.',
          required: true

    argument :external_type, GraphQL::Types::String,
          description: 'External type of the vulnerability identifier.',
          required: false

    argument :external_id, GraphQL::Types::String,
          description: 'External ID of the vulnerability identifier.',
          required: false
  end
end
