# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class MarkdownType < BaseType
      graphql_name 'VulnerabilityDetailMarkdown'
      description 'Represents the vulnerability details Markdown field'

      field :value, GraphQL::Types::String,
        null: false, description: 'Value of the Markdown field.'
    end
  end
end
