---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Repositories analytics for groups **(PREMIUM)**

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/215104) in GitLab 13.4.

Repositories analytics for groups provides information about test coverage for all projects in a group. An
[issue exists](https://gitlab.com/gitlab-org/gitlab/-/issues/273527) to also extend support for all projects in
subgroups.

It is similar to [repository analytics for projects](../../analytics/repository_analytics.md).

## Current group code coverage

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/263478) in GitLab 13.7.

The **Analytics > Repositories** group page displays the overall test coverage of all your projects in your group.
In the **Overall activity** section, you can see:

- The number of projects with coverage reports.
- The average percentage of coverage across all your projects.
- The total number of pipeline jobs that produce coverage reports.

## Average group test coverage from the last 30 days

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/215140) in GitLab 13.9.

The **Analytics > Repositories** group page displays the average test coverage of all your projects in your group in a graph for the last 30 days.

## Latest project test coverage list

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/267624) in GitLab 13.6.

To see the latest code coverage for each project in your group:

1. On the top bar, select **Main menu > Groups** and find your group.
1. On the left sidebar, select **Analytics > Repositories**.
1. In the **Latest test coverage results** section, from the **Select projects** dropdown list, choose the projects you want to check.

You can download code coverage data for specific projects using
[code coverage history](../../../ci/pipelines/settings.md#view-code-coverage-history).

## Download historic test coverage data

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/215104) in GitLab 13.4.

You can get a CSV of the code coverage data for all of the projects in your group. This report has a maximum of 1000 records. The code coverage data is from the default branch in each project.

To get the report:

1. On the top bar, select **Main menu > Groups** and find your group.
1. On the left sidebar, select **Analytics > Repositories**.
1. Select **Download historic test coverage data (.csv)**.
1. Select the projects and date range you want to include in the report.
1. Select **Download test coverage data (.csv)**.

The projects dropdown list shows up to 100 projects from your group. If the project you want to check is not in the dropdown list, you can select **All projects** to download the report for all projects in your group, including any projects that are not listed. There is a plan to improve this behavior in this [related issue](https://gitlab.com/gitlab-org/gitlab/-/issues/250684).

For each day that a coverage report was generated by a job in a project's pipeline, a row in the CSV includes:

- The date the coverage job ran
- The name of the job that generated the coverage report
- The name of the project
- The coverage value

If the project's code coverage was calculated more than once in a day, the last value from that day is used.

NOTE:
[In GitLab 13.7 and later](https://gitlab.com/gitlab-org/gitlab/-/issues/270102), group code coverage
data is taken from the configured [default branch](../../project/repository/branches/default.md).
In earlier versions, it is taken from the `master` branch.

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
