# frozen_string_literal: true

class AddIndexToVulnerabilityFindingsOnUuid < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vuln_findings_on_uuid_including_vuln_id'

  disable_ddl_transaction!

  # TODO: Index to be created synchronously in https://gitlab.com/gitlab-org/gitlab/-/issues/397740

  def up
    prepare_async_index_from_sql <<-SQL
      CREATE UNIQUE INDEX CONCURRENTLY #{INDEX_NAME} ON vulnerability_occurrences (uuid) include (vulnerability_id);
    SQL
  end

  def down
    unprepare_async_index_by_name(:vulnerability_occurrences, INDEX_NAME)
  end
end
