# frozen_string_literal: true

class AddSyncTmpPartialIndexOnVulnerabilityReportTypes < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'tmp_idx_vulnerability_occurrences_on_id_where_report_type_7_99'

  disable_ddl_transaction!

  def up
    # Temporary index to be removed in 15.11 https://gitlab.com/gitlab-org/gitlab/-/issues/393052
    add_concurrent_index :vulnerability_occurrences, :id, where: 'report_type IN (7, 99)', name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end
end
