# frozen_string_literal: true

class PrepareForVulnerabilityOccurrencesUuidTypeTransition < Gitlab::Database::Migration[2.0]
  enable_lock_retries!

  TABLE = :vulnerability_occurrences
  MAPPINGS = {
    uuid: {
      from_type: :string,
      to_type: :uuid,
      default_value: '00000000-0000-0000-0000-000000000000'
    }
  }

  def up
    create_temporary_columns_and_triggers(TABLE, MAPPINGS)
  end

  def down
    columns = MAPPINGS.keys
    temporary_columns = columns.map { |column| convert_to_type_column(column, :string, :uuid) }
    trigger_name = rename_trigger_name(TABLE, columns, temporary_columns)
    remove_rename_triggers(TABLE, trigger_name)
    temporary_columns.each { |column| remove_column(TABLE, column) }
  end
end
