# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class CreateCiUnlockPipelineRequests < Gitlab::Database::Migration[2.1]
  enable_lock_retries!

  def change
    create_table :ci_unlock_pipeline_requests, id: false do |t|
      t.references :pipeline, primary_key: true, foreign_key: { to_table: :ci_pipelines, on_delete: :cascade }
    end
  end
end
