# frozen_string_literal: true

module Ci
  class UnlockPipelineAndArtifactsWorker
    include ApplicationWorker
    include LimitedCapacity::Worker

    idempotent!

    data_consistency :always
    urgency :low

    feature_category :build_artifacts

    def perform_work(*args)
      unlock_request = Ci::UnlockPipelineRequest.pop

      return unless unlock_request

      result = Ci::UnlockPipelineAndArtifactsService.new(unlock_request.pipeline_id).execute

      log_extra_metadata_on_done(:unlocked_job_artifacts, result[:unlocked_job_artifacts])
      log_extra_metadata_on_done(:unlocked_pipeline_artifacts, result[:unlocked_pipeline_artifacts])

      unlock_request.destroy!
    rescue ActiveRecord::ActiveRecordError => e
      GitLab::AppLogger.error("failed to unlock pipeline #{unlock_request.pipeline_id}: #{e.message}")
      unlock_request.pending!
    end

    def remaining_work_count(*args)
      Ci::UnlockPipelineRequest.count
    end

    def max_running_jobs
      10
    end
  end
end
