# frozen_string_literal: true

module Ci
  class UnlockPipelineAndArtifactsService
    BATCH_SIZE = 100

    def initialize(pipeline_id)
      @pipeline_id = pipeline_id
      @unlocked_job_artifact_count = 0
      @unlocked_pipeline_artifact_count = 0
    end

    def execute
      unlock_pipeline
      unlock_job_artifacts
      # unlock_pipeline_artifacts

      {
        unlocked_job_artifacts: @unlocked_job_artifact_count,
        unlocked_pipeline_artifacts: @unlocked_job_artifact_count
      }
    end

    def unlock_pipeline
      Ci::Pipeline.where(id: @pipeline_id).update_all(locked: Ci::Pipeline.lockeds[:unlocked])
    end

    def unlock_job_artifacts
      builds_scope = Ci::Build.where(commit_id: @pipeline_id)
      Gitlab::Pagination::Keyset::Iterator.new(scope: builds_scope).each_batch(of: BATCH_SIZE) do |builds|
        job_artifact_scope = Ci::JobArtifact.artifact_artifacts_locked.where(job_id: builds.pluck(:id))

        Gitlab::Pagination::Keyset::Iterator.new(scope: job_artifact_scope).each_batch(of: BATCH_SIZE) do |job_artifacts|
          unlocked_count = Ci::JobArtifact.where(id: job_artifacts.pluck(:id)).update_all(locked: ::Ci::JobArtifact.lockeds[:unlocked])
          @unlocked_job_artifact_count += unlocked_count
        end
      end
    end
  end
end
