# frozen_string_literal: true
module Ci
  class UnlockPipelineRequest < Ci::ApplicationRecord
    self.primary_key = :pipeline_id

    belongs_to :pipeline, class_name: 'Ci::Pipeline'

    enum state: {
      pending: 0,
      in_progress: 1
    }

    def self.pop
      transaction do
        find_by_sql([update_sql, { new_request_state: self.states[:in_progress], pending_state: self.states[:pending] }]).first
      end
    end

    def self.update_sql
      <<~SQL
        UPDATE "ci_unlock_pipeline_requests"
        SET "state" = :new_request_state
        WHERE "state" = :pending_state
        AND "pipeline_id" in (
          SELECT "pipeline_id" FROM "ci_unlock_pipeline_requests"
          ORDER BY "pipeline_id" DESC LIMIT 1
        )
        RETURNING *
      SQL
    end

  end
end
