# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Sidebars::Projects::SuperSidebarMenus::SecureMenu, feature_category: :navigation do
  subject { described_class.new({}) }

  let(:items) { subject.instance_variable_get(:@items) }

  it 'has title and sprite_icon' do
    expect(subject.title).to eq(s_("Navigation|Secure"))
    expect(subject.sprite_icon).to eq("shield")
  end

  it 'defines list of NilMenuItem placeholders' do
    expect(items.map(&:class).uniq).to eq([Sidebars::NilMenuItem])
    expect(items.map(&:item_id)).to eq([
      :discover_project_security,
      :audit_events,
      :dashboard,
      :vulnerability_report,
      :on_demand_scans,
      :scan_policies,
      :dependency_list,
      :license_compliance,
      :configuration
    ])
  end
end
