# frozen_string_literal: true

module Gitlab
  module Ci
    module Reports
      module DependencyList
        class Vulnerability
          attr_reader :name, :severity, :id, :url

          def initialize(params)
            @name = params.fetch(:name)
            @severity = params.fetch(:severity)
            @id = params.fetch(:id, nil)
            @url = params.fetch(:url, nil)
          end

          def ==(other)
            self.to_hash == other.to_hash
          end

          def hash
            name.hash ^ severity.hash ^ id.hash ^ url.hash
          end

          def to_hash
            {
              name: self.name,
              severity: self.severity,
              id: self.id,
              url: self.url
            }
          end

          alias_method :eql?, :==
        end
      end
    end
  end
end
