# frozen_string_literal: true

module EE
  module API
    module Entities
      class Vulnerability < Grape::Entity
        expose :id
        expose :title
        expose :description

        expose :state
        expose :severity
        expose :confidence
        expose :report_type

        expose :project, using: ::API::Entities::ProjectIdentity

        expose :finding
        expose :resolved_on_default_branch
        expose :project_default_branch

        expose :author_id
        expose :updated_by_id
        expose :last_edited_by_id
        expose :resolved_by_id
        expose :dismissed_by_id
        expose :confirmed_by_id

        expose :start_date
        expose :due_date

        expose :created_at
        expose :updated_at
        expose :last_edited_at
        expose :resolved_at
        expose :dismissed_at
        expose :confirmed_at
      end
    end
  end
end
