# frozen_string_literal: true

module Security
  module Ingestion
    module Tasks
      class UpdateVulnerabilityUuids
        class VulnerabilityReads
          include Gitlab::Ingestion::BulkUpdatableTask

          self.model = Vulnerabilities::Read

          def initialize(uuid_hash_lookup, project)
            @uuid_hash_lookup = uuid_hash_lookup
            @project = project
          end

          private

          attr_reader :project, :uuid_hash_lookup

          def attributes
            project
              .vulnerability_reads
              .by_uuid(uuid_hash_lookup.keys)
              .map { |vr| attributes_for(vr, uuid_hash_lookup[vr.uuid]) }
          end

          def attributes_for(vulnerability_read, new_uuid)
            {
              vulnerability_id: vulnerability_read.vulnerability_id,
              uuid: new_uuid
            }
          end
        end
      end
    end
  end
end
