---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# AspNetMvc header exposes version information

## Description

The target website returns AspNet headers along with version information of this website. By
exposing these values attackers may attempt to identify if the target software is vulnerable to known
vulnerabilities. Or catalog known sites running particular versions to exploit in the future when a
vulnerability is identified in the particular version.

## Remediation

To remove the `X-AspNetMvc-Version` information set `MvcHandler.DisableMvcResponseHeader = true;` in the
`Global.asax.cs` file in the `Application_Start()` method.

```cs
protected void Application_Start()
{
    MvcHandler.DisableMvcResponseHeader = true;
}
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.6 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [IIS Remove Unwanted Headers](https://techcommunity.microsoft.com/t5/iis-support-blog/remove-unwanted-http-response-headers/ba-p/369710)
