---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "GitLab's development guidelines for Distribution"
---

# Contribute to GitLab Distribution

Learn how to add new components and services to the GitLab application.

## Support all package methods

Additions must support both Omnibus GitLab and Cloud Native GitLab. Changes
to one must be made to the other to retain feature parity.

## Contributing

The primary projects handled by Distribution are listed below. For more
information, visit the [Distribution team engineering handbook page](https://about.gitlab.com/handbook/engineering/development/enablement/systems/distribution/)
or select one of the subsections in the navigation bar.

### GitLab application

- [Omnibus GitLab](https://gitlab.com/gitlab-org/omnibus-gitlab)
- [Cloud Native GitLab (CNG)](https://gitlab.com/gitlab-org/build/CNG)
- [GitLab Operator](https://gitlab.com/gitlab-org/cloud-native/gitlab-operator)
- [GitLab Chart](https://gitlab.com/gitlab-org/charts/gitlab)

### Components and tools

- [Omnibus GitLab Builder](https://gitlab.com/gitlab-org/gitlab-omnibus-builder)
- [Omnibus Fork](https://gitlab.com/gitlab-org/omnibus)
- [GitLab Logger](https://gitlab.com/gitlab-org/cloud-native/gitlab-logger)
- [Issue Bot](https://gitlab.com/gitlab-org/distribution/issue-bot)
